# Video-Sound-Extractor.sh

---

## 🎬 **Beschreibung des Skripts `Video-Sound-Extractor.sh`**

Dieses Skript extrahiert **den Ton aus allen Videodateien in einem bestimmten Ordner** und erzeugt daraus **MP3-Dateien**.
Es verwendet dafür das Programm **ffmpeg**, das auf dem System installiert sein muss.

Das Skript ist ideal, wenn man viele Videos besitzt und deren Audio-Inhalt z. B. als Podcast, Mitschnitt, Musikspur oder Transkript–Input nutzen möchte.

---

### 🔧 **1. Definition des Zielordners**

Im Skript wird ein Ordner festgelegt:

```zsh
INPUT_DIR="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"
```

In diesem Ordner müssen die Videodateien liegen, deren Ton extrahiert werden soll.

Beispiele unterstützter Videoformate:

* `.mp4`
* `.mov`
* `.mkv`
* `.avi`
* `.webm`

---

### 🔍 **2. Durchsuchen des Ordners nach Videodateien**

Das Skript verwendet eine Schleife:

```zsh
for video in "$INPUT_DIR"/*.{mp4,mov,mkv,avi,webm}; do
```

Damit werden **alle Videodateien im Ordner** verarbeitet, die eine der angegebenen Endungen besitzen.

---

### 🎧 **3. Erstellen des Ziel-Dateinamens**

Für jede Videodatei wird der passende MP3-Name erzeugt:

```zsh
audio="${video%.*}.mp3"
```

Beispiel:

* Video: `interview.mov`
* MP3-Ausgabe: `interview.mp3`

---

### 🎛 **4. Extrahieren des Tons (ffmpeg)**

Der wichtigste Teil:

```zsh
ffmpeg -i "$video" -vn -acodec libmp3lame -ab 192k "$audio"
```

Das bedeutet:

* **-i "$video"** → Eingabedatei
* **-vn** → Video nicht mitverarbeiten („video none“)
* **-acodec libmp3lame** → Ton in MP3 umwandeln
* **-ab 192k** → MP3-Bitrate = 192 Kbit/s
* **"$audio"** → Name der erzeugten MP3-Datei

Das Ergebnis ist eine hochwertige Audio-Datei.

---

### ✔️ **5. Statusmeldungen**

Während des Ablaufs erscheint:

* `Extrahiere Audio aus: <Dateiname>`
* oder bei Erfolg z. B.: `Fertig: interview.mp3`
* beim Überspringen: `Keine gültigen Dateien gefunden.`

Damit hast du eine klare Übersicht, welche Videos bereits verarbeitet wurden.

---

## 🚀 **Wie man das Skript verwendet**

### Schritt 1 — ffmpeg installieren (falls noch nicht vorhanden)

### macOS (Homebrew):

```bash
brew install ffmpeg
```

#### macOS ohne Homebrew:

* ffmpeg als vorgefertigtes binary herunterladen (z. B. von evermeet.cx oder ffmpeg.org)

---

### Schritt 2 — Skript ausführbar machen

```bash
chmod +x Video-Sound-Extractor.sh
```
Das muss **nur einmal** gemacht werden.

---

### Schritt 3 — Skript starten

```bash
./Video-Sound-Extractor.sh
```

Das Skript:

* durchsucht automatisch den definierten Ordner
* extrahiert den Ton aus *allen* dort liegenden Videos
* legt MP3-Dateien am gleichen Ort ab

---

### Schritt 4 — Ergebnisse prüfen

Im gleichen Ordner wie die Videos erscheinen danach die MP3-Dateien.

Beispiel:

```
VIDEO/
 ├── vortrag.mp4
 ├── vortrag.mp3
 ├── meeting.mkv
 ├── meeting.mp3
```

---




