#!/bin/bash
# Script Name: Video-Sound-Extractor.sh
# Description: Extrahiert aus Videos, die in einem Ordner liegen, den Sound und speichert diesen als separate mp4-Datei. Benötigt ffmpeg auf dem Rechner.
# Author: codebase.software by Achim Schmidt
# License: GPLv3 (https://www.gnu.org/licenses/gpl-3.0.txt)
# If you like it, buy me a coffee:  https://buymeacoffee.com/achimschmidt
# ausführbar machen: chmod +x Video-Sound-Extractor.sh
#starten im Terminal mit: ./Video-Sound-Extractor.sh



# Verzeichnis festlegen
#VIDEO_DIR="/Volumes/Production/Video-Sound-Extractor"
VIDEO_DIR="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"

# Überprüfen, ob das Verzeichnis existiert
if [ ! -d "$VIDEO_DIR" ]; then
  echo "Das Verzeichnis $VIDEO_DIR existiert nicht. Überprüfe bitte den Pfad."
  exit 1
fi

# Variable für die Anzahl der gefundenen Dateien
found_files=0

# Schleife durch alle Videodateien im Verzeichnis
for video_file in "$VIDEO_DIR"/*.mp4 "$VIDEO_DIR"/*.mov; do
  # Überprüfen, ob die Datei existiert
  if [ -e "$video_file" ]; then
    found_files=1  # Setzt die Variable, wenn eine Datei gefunden wurde

    # Dateiname ohne Erweiterung extrahieren
    filename=$(basename "$video_file" | sed 's/\.[^.]*$//')

    # Ziel-Dateipfad mit m4a-Erweiterung erstellen
    output_file="$VIDEO_DIR/${filename}.m4a"

    # Sound aus dem Video extrahieren
    ffmpeg -i "$video_file" -vn -acodec aac -b:a 256k "$output_file"

    # Erfolgsmeldung
    echo "Audio erfolgreich extrahiert: $output_file"
  fi
done

# Überprüfung, ob keine Dateien gefunden wurden
if [ "$found_files" -eq 0 ]; then
  echo "Keine Videodateien im Verzeichnis gefunden."
fi

echo "Alle Audiodateien wurden extrahiert."

