# backup_folder.sh
---

# 📦 **Beschreibung des Skripts `backup_folder.sh`**

Dieses Skript erstellt ein **ZIP-Backup eines einzelnen Ordners**, der vorher im Skript festgelegt wurde.
Es erzeugt automatisch einen **Zeitstempel im Dateinamen**, prüft, ob Quell- und Zielordner existieren, und erstellt anschließend ein ZIP-Archiv des Ordners.

Das Skript ist ideal, wenn du schnell und zuverlässig **einen einzigen Plugin-Ordner, Projektordner oder beliebigen Datenordner** sichern möchtest.

---

# 🔧 **1. Quell- und Zielordner festlegen**

Zu Beginn findest du zwei Variablen:

```bash
SOURCE="/Volumes/Name der Festplatte/Pfad/zurm/Quwll-Verzeichnis/"
DESTINATION="/Volumes/Name der Festplatte/Pfad/zurm/Ziel-Verzeichnis/"
```

➡️ **SOURCE:** Ordner, der gesichert werden soll
➡️ **DESTINATION:** Ordner, in den das ZIP gespeichert wird

Diese Pfade können jederzeit angepasst werden.

---

# 🕒 **2. Erstellen eines Zeitstempels**

Das Skript erzeugt automatisch:

```bash
TIMESTAMP=$(date +"%Y-%m-%d_%H-%M-%S")
```

Beispiel:

```
2025-11-17_15-12-09
```

Dadurch erhält jede Backup-Datei einen eindeutigen Namen.

---

# 🗂️ **3. Erstellen des Archivnamens**

Aus Ordnername + Zeitstempel entsteht:

```bash
ARCHIVE_NAME="universal-license-server_2025-11-17_15-12-09.zip"
```

So erkennt man später sofort, wann das Backup angelegt wurde.

---

# 📁 **4. Existenzprüfung von Quell- und Zielordner**

Das Skript prüft zuerst:

```bash
if [ ! -d "$SOURCE" ]; then
  echo "❌ Quellordner existiert nicht!"
  exit 1
fi
```

Dann:

```bash
if [ ! -d "$DESTINATION" ]; then
  echo "❌ Zielordner existiert nicht!"
  exit 1
fi
```

➡️ Damit wird verhindert, dass ein ZIP im Nirgendwo landet.

---

# 📦 **5. Erstellen des ZIP-Archivs**

Der Kern des Skripts:

```bash
zip -r "$DESTINATION/$ARCHIVE_NAME" "$SOURCE"
```

Parameter:

* **-r** → rekursiv (alle Unterordner und Dateien)
* ZIP-Dateiname = „Ordnername + Zeitstempel“

Ergebnis:

```
/Volumes/8TB/Backups/local/universal-license-server_2025-11-17_15-12-09.zip
```

---

# ✔️ **6. Erfolgskontrolle**

Danach prüft das Skript:

```bash
if [ $? -eq 0 ]; then
  echo "✅ Backup erfolgreich erstellt: $DESTINATION/$ARCHIVE_NAME"
else
  echo "❌ Fehler beim Erstellen des Backups!"
fi
```

* **Erfolg** → grüne Bestätigung
* **Fehler** → klare Fehlermeldung

---

# 🚀 **Wie verwendet man das Skript?**

### Schritt 1 – Skript einmalig ausführbar machen

```bash
chmod +x backup_folder.sh
```

---

### Schritt 2 – Skript starten

```bash
./backup_folder.sh
```

Das Skript:

1. prüft die Ordner
2. erzeugt einen Zeitstempel
3. erstellt ein ZIP-Archiv
4. bestätigt Erfolg oder meldet Fehler

---

# 📂 Beispielausgabe

```
Starte Backup...
Quelldateien werden komprimiert...
Backup erfolgreich erstellt: /Volumes/8TB/Backups/local/universal-license-server_2025-11-17_15-12-09.zip
```

---




