#!/bin/zsh
#
# Script Name: backup_folder.sh
# Description: Erstellt ein ZIP-Backup eines Quellordners auf ein zweites Laufwerk und speichert diesen mit einem individuellen Zeitstempel.
# Author: codebase.software by Achim Schmidt
# License: GPLv3 https://www.gnu.org/licenses/gpl-3.0.txt
# 
# in den entsprechenden Ordner wechseln mit: cd
# Script ausführbar machen: chmod +x backup_folder.sh
# starten im Terminal mit: ./backup_folder.sh



# ───────────────────────────── Benutzer­anpassungen ────────────────────────────
SOURCE="/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis/"
DESTINATION="/Volumes/Name der Festplatte/Pfad/zurm/Ziel-Verzeichnis/"
# ───────────────────────────────────────────────────────────────────────────────

# Datum + Uhrzeit  (JJJJ-MM-TT_hh-mm)
DATETIME=$(date +"%Y-%m-%d_%H%M")

# Letzten Ordnernamen aus dem SOURCE-Pfad ermitteln
FOLDER_NAME="$(basename "$SOURCE")"

# Archivname: <Ordnername>_<Datum>_<Uhrzeit>.zip
ARCHIVE_NAME="${DATETIME}_${FOLDER_NAME}.zip"

# Zielordner anlegen (falls nicht vorhanden)
mkdir -p "$DESTINATION"

# Archiv erstellen – nur den Quellordner selbst verpacken
echo "📦 Erstelle Archiv von $SOURCE …"
(
  cd "$(dirname "$SOURCE")" || {
    echo "❌ Fehler: Konnte Quellverzeichnis nicht betreten!"
    exit 1
  }
  zip -rq "$DESTINATION/$ARCHIVE_NAME" "$FOLDER_NAME"
)

# Erfolgsmeldung
if [ $? -eq 0 ]; then
  echo "✅ Backup erfolgreich erstellt: $DESTINATION/$ARCHIVE_NAME"
else
  echo "❌ Fehler beim Erstellen des Backups!"
fi
