# backup_multi_folders.sh
---

# 📦 **Beschreibung des Skripts `backup_multi_folders.sh`**

Dieses Skript erstellt **ein einziges ZIP-Archiv**, das **mehrere unterschiedliche Ordner** enthält.
Du kannst vor dem Start auswählen, **welche der vordefinierten Ordner tatsächlich ins Backup sollen**, und du kannst **den Namen des ZIP-Archivs vor dem Erstellen ändern**.

Das Skript ist ideal, wenn du regelmäßig mehrere Projekte, Plugin-Ordner oder Dokumentordner in **einer gemeinsamen Archivdatei** sichern möchtest.

---

# 🔧 1. **Zielordner festlegen**

Zu Beginn steht:

```bash
DESTINATION="/Volumes/Name der Festplatte/Pfad/zurm/Ziel-Verzeichnis/"
```

➡️ Dort wird später das ZIP-Archiv gespeichert.
Das Skript prüft später, ob der Ordner existiert – sonst bricht es ab.

---

# 🗂️ 2. **Liste der zu sichernden Ordner**

Im Skript steht eine Liste:

```bash
FOLDERS=(
  "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_1/"
  "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_2/"
  "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_3/"
  ...
)
```

Das sind **alle potenziellen Ordner**, die du optional ins Backup aufnehmen kannst.

---

# 🧲 3. **Anzeige der verfügbaren Ordner zur Auswahl**

Beim Start zeigt das Skript alle Ordner durchnummeriert an.

Beispiel:

```
1) /Volumes/.../uell-Verzeichnis_1
2) /Volumes/.../uell-Verzeichnis_2
3) /Volumes/.../uell-Verzeichnis_3
...
```

Du kannst anschließend **jeden Ordner entfernen**, den du nicht sichern möchtest.

Das passiert durch:

```bash
read -p "Welche Ordner möchtest du entfernen? (z. B. 2 4 5): " REMOVE_IDS
```

➡️ Du gibst nur die Nummern ein, nicht die Pfade.

---

# 🗃️ 4. **Erstellen einer reduzierten Ordnerliste**

Das Skript entfernt nun alle Ordnernummern, die du angegeben hast.

Danach erscheint eine Liste:

```
Folgende Ordner werden gesichert:
 - /Volumes/.../plugin1
 - /Volumes/.../theme2
 - /Volumes/.../config
```

---

# 📝 5. **Archivname anzeigen und änderbar machen**

Das Skript schlägt einen Standardnamen vor:

```
backup_2025-11-17_14-33-21.zip
```

Dann wirst du gefragt:

```
Möchtest du den Namen ändern? (j/n):
```

* **j** → Du gibst einen eigenen Archivnamen ein
* **n** → Der vorgeschlagene Name wird verwendet

Damit ist das Archiv immer korrekt benannt.

---

# 📦 6. **Erstellen des ZIP-Archivs**

Wichtig: Das Archiv enthält **alle ausgewählten Ordner gemeinsam**.

Der Befehl:

```bash
zip -r "$DESTINATION/$ARCHIVE_NAME" "${SELECTED_FOLDERS[@]}"
```

Parameter:

* **-r** = rekursiv → Zippt alles inkl. Unterordner
* Ergebnis: Ein einziges Archiv, z. B.:

  ```
  /Volumes/8TB/Backups/coding-NAS/mein_backup.zip
  ```

---

# ✔️ 7. **Erfolgsmeldung**

Am Ende kommt:

```
Backup erfolgreich erstellt: /Volumes/.../mein_backup.zip
```

Falls ein Fehler auftritt, gibt das Skript eine klare Fehlermeldung aus.

---

# 🚀 **Wie verwendet man das Skript?**

### 1. ausführbar machen

Nur einmal nötig:

```bash
chmod +x backup_multi_folders.sh
```

---

### 2. starten

```bash
./backup_multi_folders.sh
```

---

### 3. Auswahl treffen

* Liste der Ordner ansehen
* Zahlen eingeben, um Ordner abzuwählen

---

### 4. Archivname anpassen

* vorgeschlagenen Namen übernehmen
  oder
* eigenen Namen eingeben

---

### 5. Warten, bis ZIP erstellt wurde

Im Zielordner findest du dann **ein einziges ZIP**, das mehrere Ordner enthält.

---

# 📂 Beispiel

Zu sichernde Ordner:

* /project1
* /project2
* /themes/theme1

Ergebnis:

```
coding-NAS/
 └── backup_2025-11-17_14-33-21.zip
```

Inhalt:

```
project1/
project2/
theme1/
```

---

# ✅ ** *backup_multi_folders.sh* (Standardversion)**

### ✦ Charakteristik

Dieses Skript ist **nicht interaktiv**.
Alle Einstellungen werden **vorab im Skript festgelegt**, u. a.:

* feste Quellverzeichnisse
* fester Zielordner
* automatischer Archivname (Zeitstempel)
* keine Benutzerabfragen

### ✦ Ablauf

1. Zeitstempel erzeugen
2. ZIP-Archivname automatisch generieren
3. ZIP-Archiv erstellen
4. Erfolg/Fehler ausgeben

### ✦ Einsatz

Ideal, wenn du das Skript als **Routine-Backup** verwendest – z. B. als Cron-Job oder per Doppelklick.


