# backup_multi_folders_interactive.sh

---

# 📦 **Beschreibung des Skripts `backup_multi_folders_interactive.sh`**

Dieses Skript erstellt **ein ZIP-Archiv**, das **mehrere Ordner enthält**, wobei du während der Ausführung interaktiv auswählen kannst:

1. welche Ordner ins Backup sollen
2. wie das ZIP-Archiv heißen soll

Es kombiniert also **Flexibilität** mit **automatischer Archivierung**.

Es ist ideal, wenn du häufig verschiedene Ordner sicherst, aber jedes Mal selbst entscheiden möchtest, was ins Backup kommt.

---

# 🔧 1. **Zielordner für das Backup festlegen**

Zu Beginn steht:

```bash
DESTINATION="/Volumes/Name der Festplatte/Pfad/zurm/Ziel-Verzeichnis/"
```

➡️ Das ZIP-Archiv wird in diesem Ordner gespeichert.

Das Skript prüft später, ob dieser Ordner existiert.

---

# 📁 2. **Liste der möglichen Backup-Ordner**

Vordefiniert:

```bash
FOLDERS=(
 "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_1/"
 "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_2/"
  "/Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_3/"
  ...
)
```

Das sind *potenzielle* Backup-Ordner.

---

# 📊 3. **Interaktive Ordnerauswahl**

Beim Start zeigt das Skript die Ordner als Liste:

```
(1)  /Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_1/
(2) /Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_2/
(3) /Volumes/Name der Festplatte/Pfad/zurm/Quell-Verzeichnis_3/
...
```

Dann die Frage:

```
Bitte gib die Nummern der Ordner an, die du NICHT sichern möchtest (z. B. 2 5 6):
```

➡️ Du entfernst Ordner durch Eingabe ihrer Nummern
➡️ Alle übrigen Ordner werden gesichert

Das ist besonders praktisch, wenn du normalerweise alle sichern würdest, aber einige abwählen möchtest.

---

# 🗂️ 4. **Zusammenstellen der finalen Ordnerliste**

Das Skript baut nun automatisch eine Liste aller Ordner, die **tatsächlich** ins Backup sollen.

Die Ausgabe:

```
Diese Ordner werden gesichert:
 - /Volumes/.../Quell-Verzeichnis_1
 - /Volumes/.../Quell-Verzeichnis_2
 - /Volumes/.../Quell-Verzeichnis_3
```

---

# 📝 5. **Erstellen und Anpassen des Archivnamens**

Das Skript erzeugt zunächst einen Standardnamen:

```
backup_2025-11-17_14-41-50.zip
```

Dann wirst du gefragt:

```
Möchtest du einen eigenen Namen vergeben? (j/n)
```

* **n** → Der vorgeschlagene Name wird übernommen
* **j** → Du gibst einen eigenen Namen ein, z. B.:

  ```
  mein_code_backup.zip
  ```

---

# 📦 6. **Erstellen des ZIP-Archivs**

Das Archiv wird mit folgendem Befehl erstellt:

```bash
zip -rq "$DESTINATION/$ARCHIVE_NAME" "${SELECTED_FOLDERS[@]}"
```

Parameter:

* **-r** → rekursiv (alle Unterordner und Dateien)
* **-q** → quiet mode (wenig Konsole-Ausgabe)

Ergebnis:
Ein einzelnes ZIP-Archiv, das alle ausgewählten Ordner enthält.

---

# ✔️ 7. **Erfolgsmeldung**

Nach dem erfolgreichen Backup erscheint:

```
Backup erfolgreich erstellt: /Volumes/8TB/Backups/coding-NAS/mein_code_backup.zip
```

Falls der Zielordner nicht existiert oder das ZIP fehlschlägt, erscheint eine klare Fehlermeldung.

---

# 🚀 **Wie verwendet man das Skript?**

### Schritt 1 – ausführbar machen

Nur einmal nötig:

```bash
chmod +x backup_multi_folders_interactive.sh
```

---

### Schritt 2 – Skript starten

```bash
./backup_multi_folders_interactive.sh
```

---

### Schritt 3 – Ordner auswählen

* Liste ansehen
* Nummern eingeben, die **nicht** ins Backup sollen

---

### Schritt 4 – Archivname bestätigen oder ändern

* Entweder Standardname übernehmen
* Oder eigenen Namen eingeben

---

### Schritt 5 – ZIP wird erstellt

Das Ergebnis liegt im Zielordner.

---

# 📂 Beispielausgabe

```
(1) /Volumes/.../plugin1
(2) /Volumes/.../plugin2
(3) /Volumes/.../theme1

Welche Ordner möchtest du ausschließen? 2

Diese Ordner werden gesichert:
- /Volumes/.../plugin1
- /Volumes/.../theme1

Name des Archivs (Enter für Standardnamen backup_2025-11-17_14-41-50.zip):
>> mein_backup.zip

Backup erfolgreich erstellt: /Volumes/.../mein_backup.zip
```
---

---
# 🟦 ** *backup_multi_folders_interactive.sh* (Interaktive Version)**

### ✦ Charakteristik

Dieses Skript ist eine **erweiterte, interaktive Variante**.
Es erlaubt es dir beim Start, **Auswahlentscheidungen zu treffen**, bevor das ZIP erstellt wird.

### ✦ Zusätzliche Funktionen

✔ **Anzeige der Quellverzeichnisse beim Start**
✔ **Möglichkeit, einzelne Ordner abzuwählen**
✔ **Bearbeiten des vorgeschlagenen Archivnamens**
✔ **Interaktive Eingabe statt fix programmierter Werte**
✔ **Ausführlichere Fehlerprüfung (z. B. Ordner existiert nicht)**
✔ **Mehr Konsolen-UI (Menüs, Info-Ausgaben, farbige Hinweise)**

### ✦ Ablauf (erweitert)

1. Quellverzeichnisse anzeigen
2. Benutzer kann Ordner entfernen
3. Vorschlag für Archivnamen anzeigen
4. Benutzer kann Archivnamen ändern
5. ZIP-Archiv wird mit den ausgewählten Ordnern erstellt
6. Erfolg/Fehler-Meldung mit detaillierter Ausgabe

### ✦ Einsatz

Ideal, wenn du **bei jedem Backup individuell entscheiden** möchtest,
welche Ordner in das ZIP kommen und wie das Archiv heißen soll.

---