# clean_filenames.sh
---

# 🧹 **Beschreibung des Skripts `clean_filenames.sh`**

Dieses Skript bereinigt Dateinamen in einem bestimmten Ordner, indem es **unerwünschte Zeichen entfernt oder ersetzt**.
Es sorgt dafür, dass Dateinamen sauber, einheitlich und kompatibel bleiben – ideal für Webprojekte, Backups oder Migrationen.

Das Skript verändert ausschließlich **Dateinamen**, niemals Inhalte.

---

# 🔧 **1. Zielordner festlegen**

Ganz am Anfang definiert das Skript:

```bash
TARGET_DIR="/Volumes/.../Ziel-Verzeichnis"
```

➡️ In diesem Ordner werden alle Dateien bereinigt.
Der Pfad kann jederzeit angepasst werden.

---

# 🔍 **2. Prüfen, ob der Ordner existiert**

```bash
if [ ! -d "$TARGET_DIR" ]; then
  echo "❌ Zielordner existiert nicht!"
  exit 1
fi
```

Falls der Ordner fehlt → beendet sich das Skript.

---

# 🧠 **3. Liste der ungewünschten Zeichen / Muster**

Das Skript definiert Regeln, die in jedem Dateinamen ausgeführt werden:

```bash
newname=$(echo "$basename" \
  | sed -e 's/[äáàâ]/ae/g' \
		's/[öóòô]/oe/g' \
		's/[üúùû]/ue/g' \
		's/ß/ss/g' \
		's/ /_/g' \
		's/[^A-Za-z0-9._-]/_/g')
```

### Folgende Umwandlungen finden statt:

#### 1️⃣ **Umlaute werden ASCII-kompatibel ersetzt**

* ä, á, à, â → **ae**
* ö, ó, ò, ô → **oe**
* ü, ú, ù, û → **ue**
* ß → **ss**

#### 2️⃣ **Leerzeichen werden ersetzt**

* Leerzeichen → **Unterstriche**

#### 3️⃣ **Unerlaubte Sonderzeichen werden neutralisiert**

Alles, was nicht:

* Buchstabe,
* Zahl,
* Punkt,
* Unterstrich,
* Bindestrich ist,

wird durch **„_“** ersetzt.

Damit gehören Kommas, Klammern, Sonderzeichen, Emojis oder exotische Unicode-Zeichen zu den ersetzten Elementen.

Beispiele:

| Originalname         | Neuer Name            |
| -------------------- | --------------------- |
| `mein Dokument.pdf`  | `mein_Dokument.pdf`   |
| `küche (alt).txt`    | `kueche__alt_.txt`    |
| `ßonderangebot!.jpg` | `ssonderangebot_.jpg` |

---

# 🔁 **4. Verarbeitung aller Dateien**

Das Skript durchläuft jede Datei:

```bash
for file in "$TARGET_DIR"/*; do
```

→ Unterordner werden ignoriert
→ Nur Dateien im Hauptverzeichnis werden umbenannt

---

# ✏️ **5. Umbenennen der Dateien**

Wenn der neue Name vom alten abweicht:

```bash
mv "$file" "$TARGET_DIR/$newname"
echo "Umbenannt: $basename → $newname"
```

➡️ es wird **nur der Name geändert**, nicht der Speicherort.

---

# 🚀 **Wie verwendet man das Skript?**

### Schritt 1 – Ausführbar machen

Nur einmal notwendig:

```bash
chmod +x clean_filenames.sh
```

---

### Schritt 2 – Skript ausführen

```bash
./clean_filenames.sh
```

Das Skript:

* liest alle Dateinamen
* ersetzt Umlaute & problematische Zeichen
* ersetzt Leerzeichen
* schreibt jeden neuen Namen ins Terminal

---

# 📂 Vorher–Nachher-Beispiele

### Vorher:

```
Küche neu.JPG
Daten (alt).csv
test#file!.txt
äßöü.pdf
```

### Nachher:

```
Kueche_neu.JPG
Daten__alt_.csv
test_file_.txt
aessoeeue.pdf
```

---



