#!/bin/bash
# Durchsucht Verzeichnisse, löscht Leerzeichen am Anfang und ersetzt Leerzeichen im Dateinamen durch Bindestriche. Außerdem werden leere Ordner gelöscht.
# Author: codebase.software by Achim Schmidt
# License: GPLv3 (https://www.gnu.org/licenses/gpl-3.0.txt)
# If you like it, buy me a coffee:  https://buymeacoffee.com/achimschmidt
# ausführbar machen mit: chmod +x clean_filenames.sh 
# starten mit: ./clean_filenames.sh

# Verzeichnis, das durchsucht werden soll. 
# Hier kann z.B. "/Volumes/NameDerFestplatte" oder ein anderer Pfad eingetragen werden.
VOLUME_PATH="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"
#!/bin/bash
#---------------------------------------------------


# Variable zur Zählung der geänderten Dateien und Ordner
changed_files_count=0
changed_dirs_count=0

# Funktion, um Leerzeichen am Anfang zu entfernen und Leerzeichen durch Bindestriche zu ersetzen
clean_filename() {
	local filepath="$1"
	local filename="$(basename "$filepath")"
	local directory="$(dirname "$filepath")"

	# Entferne führende Leerzeichen
	local new_filename="${filename## }"

	# Ersetze alle Leerzeichen im Namen durch Bindestriche
	new_filename="${new_filename// /-}"

	# Prüfe, ob der Name sich geändert hat
	if [[ "$filename" != "$new_filename" ]]; then
		mv "$filepath" "$directory/$new_filename"
		echo "Umbenannt: '$filepath' -> '$directory/$new_filename'"
		((changed_files_count++))
	fi
}

# Funktion, um Leerzeichen in Ordnernamen durch Bindestriche zu ersetzen
clean_directory_name() {
	local dirpath="$1"
	local dirname="$(basename "$dirpath")"
	local parent_directory="$(dirname "$dirpath")"

	# Ersetze alle Leerzeichen im Namen durch Bindestriche
	local new_dirname="${dirname// /-}"

	# Prüfe, ob der Name sich geändert hat
	if [[ "$dirname" != "$new_dirname" ]]; then
		mv "$dirpath" "$parent_directory/$new_dirname"
		echo "Umbenannt: '$dirpath' -> '$parent_directory/$new_dirname'"
		((changed_dirs_count++))
	fi
}

# Funktion, um leere Ordner in den Papierkorb zu verschieben
move_empty_directories_to_trash() {
	find "$VOLUME_PATH" -type d -empty | while read -r dir; do
		if [ -d "$dir" ]; then
			mv "$dir" ~/.Trash/
			echo "Leerer Ordner in den Papierkorb verschoben: '$dir'"
		fi
	done
}

# Suche nach allen Ordnern (von tiefster Ebene zuerst) und rufe die Funktion auf
echo "Starte Durchsuchung aller Ordner im Verzeichnis: $VOLUME_PATH"
find "$VOLUME_PATH" -type d | sort -r | while read -r dir; do
	clean_directory_name "$dir"
done

# Suche nach allen Dateien und rufe die Funktion auf
echo "Starte Durchsuchung des Verzeichnisses: $VOLUME_PATH"
find "$VOLUME_PATH" -type f | while read -r file; do
	clean_filename "$file"
done

# Verschiebe leere Ordner in den Papierkorb
echo "Verschiebe leere Ordner in den Papierkorb im Verzeichnis: $VOLUME_PATH"
move_empty_directories_to_trash

echo "Fertig!"
echo "Anzahl der geänderten Dateien: $changed_files_count"
echo "Anzahl der geänderten Ordner: $changed_dirs_count"
