# copy_folder_and_control.sh
---

# 📁 **Beschreibung des Skripts `copy_folder_and_control.sh`**

Dieses Skript kopiert einen Ordner inklusive sämtlicher Unterordner und Dateien an einen neuen Speicherort – **und überprüft anschließend**, ob die Kopie vollständig und korrekt erstellt wurde.

Es kombiniert also:

1. **Ordner kopieren**
2. **Datenintegrität prüfen**
3. **Erfolg oder Fehler melden**

Das Skript ist ideal, wenn man wichtige Dateien auf einen anderen Datenträger oder ein Backup-Medium kopieren und dabei sicherstellen möchte, dass nichts verloren geht.

---

# 🔧 **1. Festlegen von Quell- und Zielpfad**

Am Anfang des Skripts stehen zwei Variablen:

```zsh
SOURCE="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"
DEST="/Volumes/Name der Festplatte/1. Ordner/.../Ziel-Ordner/"
```

➡️ **SOURCE** = Der Ordner, der kopiert werden soll
➡️ **DEST** = Der Ort, an den der Ordner übertragen wird

Das Zielverzeichnis wird später automatisch angelegt.

---

# 📂 **2. Anlegen des Zielordners**

```zsh
mkdir -p "$DEST"
```

* Existiert der Zielordner nicht → wird er erstellt
* Existiert er bereits → passiert nichts

---

# 📀 **3. Kopieren des gesamten Ordners**

Das Skript nutzt `rsync`, ein effizientes Kopierwerkzeug:

```zsh
rsync -avh --delete "$SOURCE/" "$DEST/"
```

Die Parameter bedeuten:

* **-a** = Archivmodus (kopiert alles 1:1 inklusive Unterordner, Rechten, Zeitstempeln)
* **-v** = verbose (zeigt Kopiervorgang im Terminal an)
* **-h** = menschenlesbare Größen
* **--delete** = löscht im Zielordner Dateien, die im Quellordner nicht mehr existieren
  (→ Ziel wird synchron gehalten)

Efﬁzient, sicher und ideal für Backups.

---

# 🔍 **4. Überprüfung der Kopie**

Zur Kontrolle wird erneut `rsync` genutzt:

```zsh
rsync -avhn --delete "$SOURCE/" "$DEST/" > /tmp/rsync_check.log
```

* **-n** = "dry run", also *keine* echten Änderungen
* das Ergebnis wird in eine Log-Datei geschrieben

Wenn diese Überprüfung **keine Unterschiede** findet, bedeutet das:

✔️ Die Kopie ist vollständig
✔️ Quelle und Ziel sind identisch

---

# 📘 **5. Auswertung der Log-Datei**

Das Skript prüft:

```zsh
if [ ! -s /tmp/rsync_check.log ]; then
```

➡️ Wenn die Log-Datei **leer** ist:

```
Alles erfolgreich kopiert!
```

➡️ Wenn die Log-Datei **Einträge enthält**:

```
Unterschiede gefunden! Bitte die Log-Datei überprüfen.
```

Damit weißt du sofort, ob beim Kopieren etwas schiefgelaufen ist.

---

# 🚀 **Wie man das Skript verwendet**

### Schritt 1 – Skript ausführbar machen

Nur einmal nötig:

```bash
chmod +x copy_folder_and_control.sh
```

---

### Schritt 2 – Skript starten

```bash
./copy_folder_and_control.sh
```

Das Skript:

1. Kopiert den gesamten Quellordner zum Ziel
2. Synchronisiert ihn vollständig
3. Überprüft die Integrität
4. Gibt aus, ob alles erfolgreich übertragen wurde

---

# 📂 **Beispielausgabe**

```
Starte Kopiervorgang...
sending incremental file list
...

Kopiervorgang abgeschlossen.

Prüfe Integrität...
Keine Unterschiede festgestellt.

Alles erfolgreich kopiert!
```

---



