#!/bin/bash

# Script Name: copy_folder_and_control
# Description: Kopiert alle Dateien inklusive Unterordner von einem Volume-Pfad zum anderen. 
# Zudem wird die erfolgreiche Übertragung kontrolliert und ggf. werden fehlgeschlagene Übertragungen wiederholt.
# Author: codebase.software by Achim Schmidt
# License: GPLv3 (https://www.gnu.org/licenses/gpl-3.0.txt)
# If you like it, buy me a coffee:  https://buymeacoffee.com/achimschmidt
#
#starten im Terminal mit: ./copy_folder_and_control.sh
# ausführbar machen mit: chmod +x copy_folder_and_control.sh

# Quell-Verzeichnis festlegen
#SOURCE_VOLUME_PATH="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"
#-----------------------------------------------------------------------------

# Definiere Quell- und Zielverzeichnisse
SOURCE_VOLUME_PATH="/Volumes/Name der Festplatte/1. Ordner/.../Quell-Ordner/"
DEST_VOLUME_PATH="/Volumes/Name der Festplatte/1. Ordner/.../Ziel-Ordner/"

# Funktion zur Protokollierung
log() {
	echo "$(date +'%Y-%m-%d %H:%M:%S') - $1"
}

# Kopieren der Dateien inkl. Unterordnern
log "Starte Kopieren von $SOURCE_VOLUME_PATH nach $DEST_VOLUME_PATH"
rsync -av --progress "$SOURCE_VOLUME_PATH/" "$DEST_VOLUME_PATH/"

# Überprüfung der Dateien nach der Übertragung
log "Starte Überprüfung der übertragenen Dateien"
DIFF_FILES=$(diff -qr "$SOURCE_VOLUME_PATH" "$DEST_VOLUME_PATH" | grep -E 'Files .* differ|Only in')

# Falls Unterschiede gefunden wurden
if [ -n "$DIFF_FILES" ]; then
	log "Es wurden Fehler bei der Übertragung festgestellt."
	echo "$DIFF_FILES"
	
	log "Starte erneute Übertragung der fehlerhaften Dateien"
	# Erneute Übertragung der fehlerhaften Dateien
	while IFS= read -r line; do
		if [[ $line == "Only in"* ]]; then
			# Extrahiere den Pfad für fehlende Dateien
			DIR_PATH=$(echo "$line" | awk '{print $3}' | tr -d ':')
			FILE_NAME=$(echo "$line" | awk '{print $4}')
			SRC_FILE="$DIR_PATH/$FILE_NAME"
			RELATIVE_PATH="${SRC_FILE#*$SOURCE_VOLUME_PATH/}"
			DEST_FILE="$DEST_VOLUME_PATH/$RELATIVE_PATH"
			
			if [ -d "$SRC_FILE" ]; then
				mkdir -p "$DEST_FILE"
			else
				rsync -av "$SRC_FILE" "$DEST_FILE"
			fi
		elif [[ $line == "Files"* ]]; then
			# Extrahiere die Pfade für abweichende Dateien
			SRC_FILE=$(echo "$line" | awk '{print $2}')
			DEST_FILE=$(echo "$line" | awk '{print $4}')
			rsync -av "$SRC_FILE" "$DEST_FILE"
		fi
	done <<< "$DIFF_FILES"
else
	log "Alle Dateien wurden erfolgreich übertragen."
fi

log "Skript abgeschlossen."
